<?php

	add_action( 'wp_enqueue_scripts', 'ohio_child_local_enqueue_parent_styles' );

	function ohio_child_local_enqueue_parent_styles() {
		wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	}


function ohio_portfolio_shortcode() {
	
//     $project = OhioHelper::get_storage_item_data();
    $tags = get_terms(array(
        'taxonomy' => 'ohio_portfolio_tags',
        'hide_empty' => true,
    ));

    if (is_wp_error($tags) || empty($tags)) {
        return '<p>No tags found. Please check if the taxonomy "ohio_portfolio_tags" exists and has terms.</p>';
    }

    ob_start(); ?>

    <div class="portfolio-filter">
        <select id="portfolio-filter-select">
            <?php foreach ($tags as $tag) : ?>
                <option value="<?php echo esc_attr($tag->slug); ?>"><?php echo esc_html($tag->name); ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="ak-portfolio-carousel">
        <?php
        $portfolio_items = new WP_Query(array(
            'post_type' => 'ohio_portfolio',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'ohio_portfolio_tags',
                    'field' => 'slug',
                    'terms' => wp_list_pluck($tags, 'slug')
                )
            )
        ));

        if ($portfolio_items->have_posts()) :
            while ($portfolio_items->have_posts()) : $portfolio_items->the_post();
                $item_classes = '';
                $item_tags = wp_get_post_terms(get_the_ID(), 'ohio_portfolio_tags');
                foreach ($item_tags as $tag) {
                    $item_classes .= $tag->slug . ' ';
                }
                ?>
                <div class="ak-portfolio-item <?php echo esc_attr(trim($item_classes)); ?>">
                    <?php the_post_thumbnail('medium'); ?>
					
<!--                     <h2><?php the_title(); ?></h2> -->
					
					<?php
						global $post;

						# Project settings
						$project = OhioObjectParser::parse_to_project_object( $post );
						$area = "";

						if (!empty($project['custom_fields'])) :
							foreach ($project['custom_fields'] as $custom_field) : 
								if(esc_html($custom_field['title']) == "Area" || esc_html($custom_field['title']) == "area"){
									$area = esc_html($custom_field['value']);
								}
							endforeach;
						endif;
						if($area != "")echo '<h2><i class="fa-solid fa-location-dot"></i>'.$area.'</h2>';
					?>

                </div>
            <?php endwhile;
            wp_reset_postdata();
        else : ?>
            <p>No portfolio items found.</p>
        <?php endif; ?>
    </div>

    <?php return ob_get_clean();
}
add_shortcode('ohio_portfolio_filter', 'ohio_portfolio_shortcode');


function enqueue_slick_carousel() {
    wp_enqueue_style('slick-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css');
    wp_enqueue_style('slick-carousel-theme-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css');
    wp_enqueue_script('slick-carousel-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_slick_carousel');

function add_custom_carousel_script() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
		var oldHtml = $('.ak-portfolio-carousel').html();
        function initializeSlick() {
            $('.ak-portfolio-carousel').slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 2000,
                arrows: true,
                dots: false,
				infinite: true,
                responsive: [
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: 3
                        }
                    },
                    {
                        breakpoint: 600,
                        settings: {
                            slidesToShow: 1
                        }
                    }
                ]
            });
        }
		initializeSlick();
		
        $('#portfolio-filter-select').on('change', function() {
            var filter = $(this).val();
//             $('.ak-portfolio-carousel').slick('slickFilter','.'+filter);
			
            $('.ak-portfolio-carousel').slick('unslick');
			$('.ak-portfolio-carousel').html(oldHtml);
			
			$('.ak-portfolio-item').not("."+filter).remove();

            initializeSlick();
        });
        $('#portfolio-filter-select').trigger('change');
    });
    </script>
    <?php
}
add_action('wp_footer', 'add_custom_carousel_script');
