<?php
$have_wpml = function_exists( 'icl_get_languages' );
$wpml_show_in_header = OhioOptions::get_global( 'wpml_show_in_header', true );
$fullscreen_have_social = OhioOptions::get_global( 'page_hamburger_social_networks_visibility', true );
$fullscreen_have_lang = OhioOptions::get_global( 'page_hamburger_lang_switcher_visibility', true );
$header_overlay_footer_has_left = have_rows( 'global_page_overlay_menu_footer_items_left', 'option' );
$menu_position = OhioOptions::get_global( 'page_header_menu_position', 'left', true );
$in_new_tab = OhioOptions::get_global( 'social_network_target_blank', true );
$links_target = ( $in_new_tab ) ? '_blank' : '_self';
$social_link_type = OhioOptions::get_global( 'page_hamburger_menu_social_networks_type', 'default', true );
$social_link_type_class = '';

if ( $social_link_type != 'default' ) {
	$social_link_type_class = '-'.$social_link_type;
}
?>

<div class="clb-popup hamburger-nav">
    <div class="header close-bar -<?php echo esc_attr( $menu_position ); ?>-flex">
        <button aria-label="close" class="icon-button -light">
			<svg fill="#fff" height="50px" width="40px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 476.491 476.491" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <polygon points="476.491,223.246 136.539,223.246 136.539,101.706 0,238.246 136.539,374.786 136.539,253.246 476.491,253.246 "></polygon> </g></svg>
		    <?php // get_template_part( 'parts/elements/icon_close' ); ?>
		</button>
		<div class="">
		
	<?php get_template_part( 'parts/elements/menu_logo' ); ?>
			</div>
		<div class="right-part">
	<?php get_template_part( 'parts/elements/menu_optional' ); ?>
	</div> 
		
    </div>
	
	
    <div class="hamburger-nav-holder">
        <?php
            $menu = OhioOptions::get_global( 'page_hamburger_menu' );

            if ( is_nav_menu( $menu ) ) {
                wp_nav_menu( [ 'menu' => $menu, 'menu_id' => 'secondary-menu' ] );
            } else {
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu( [ 'theme_location' => 'primary', 'menu_id' => 'secondary-menu' ] );
                } else {
                    echo '<a href="' . esc_url( home_url( '/' ) ) . 'wp-admin/nav-menus.php" class="menu-blank button -outlined" target="_blank" id="menu-primary">' . esc_html__( 'Please, assign a menu', 'ohio' ) . ' <i class="icon -right"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-up-right-square" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M15 2a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2zM0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2zm5.854 8.803a.5.5 0 1 1-.708-.707L9.243 6H6.475a.5.5 0 1 1 0-1h3.975a.5.5 0 0 1 .5.5v3.975a.5.5 0 1 1-1 0V6.707l-4.096 4.096z"/></svg></i></a>';
                }
            }
        ?>
		<h4>
			Blogs
		</h4>
		<?php  echo do_shortcode('[bdp_post_carousel show_date="false" show_author="false" show_tags="false" show_comments="false" show_category="false" dots="false" autoplay="false"]'); ?>
    </div>
    <div class="hamburger-nav-details">
		
		<?php if ( $have_wpml && $wpml_show_in_header && $fullscreen_have_lang ) : ?>
			<div class="details-column">
				<?php get_template_part( 'parts/elements/lang_dropdown' ); ?>  
			</div>
		<?php endif; ?>

		<?php while ( have_rows( 'global_page_overlay_menu_footer_items_left', 'option' ) ): the_row(); ?>
			<div class="details-column">
				<?php echo wp_kses( get_sub_field( 'items' ), 'post' ); ?>
			</div>
		<?php endwhile; ?>

		<?php if ( $fullscreen_have_social ) : ?>
			<div class="details-column social-networks <?php echo esc_attr( $social_link_type_class ); ?>">
				<?php get_template_part( 'parts/elements/social_networks' ); ?>
			</div>
		<?php endif; ?>
    </div>
</div>