<?php
/**
 * Ohio WordPress Theme
 *
 * Scroll to the top template
 *
 * @author Colabrio
 * @link   https://ohio.clbthemes.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get theme options
$show_scroll = OhioOptions::get( 'page_show_arrow', true );
$show_scroll_tablet = OhioOptions::get( 'page_show_arrow_tablet', false );
$scroll_top_position = OhioOptions::get( 'page_arrow_position' );

$extra_classes = '';

if ( !$show_scroll ) {
	$extra_classes .= ' vc_hidden-lg';
}
if ( !$show_scroll_tablet ) {
	$extra_classes .= ' vc_hidden-md';
}
if ( $scroll_top_position == 'bottom_left' ) {
	$extra_classes .= ' -left';
}
if ( $scroll_top_position == 'bottom_right' ) {
	$extra_classes .= ' -right';
}

?>
    <div class="scroll-top-holder titles-typo">
		<?php esc_html_e( 'Go to Top', 'ohio' ); ?>
	</div>
<a href="#" class="scroll-top -undash -small-t<?php echo esc_attr( $extra_classes ); ?>">

	<?php if ( $scroll_top_position == 'bottom_left' || $scroll_top_position == 'bottom_right' ) : ?>

		<button class="icon-button -small -no-transition" aria-controls="site-navigation" aria-expanded="false">
		    <i class="icon -no-transition">
		    	<svg enable-background="new 0 0 32 32" height="32px" id="Слой_1" version="1.1" viewBox="0 0 32 32" width="32px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M16.714,11.297c-0.389-0.389-1.039-0.389-1.429,0l-8.999,8.976  c-0.394,0.394-0.394,1.033,0,1.426c0.394,0.394,1.034,0.394,1.428,0L16,13.436l8.285,8.264c0.395,0.394,1.034,0.394,1.429,0  c0.394-0.394,0.394-1.033,0-1.426L16.714,11.297z" fill="#E5CF3A" id="Expand_Less"/><g/><g/><g/><g/><g/><g/></svg>
		    </i>
		</button>

	<?php else : ?>

		<div class="scroll-top-bar">
			<div class="scroll-track"></div>
		</div>

	<?php endif; ?>

	
</a>